dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 3, 305, 400, "assets/images/table/redtable", "assets/images/food/item_mark1", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 250;

-- Group 1
guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 3, 3000);


-- Group 2


guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male04;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(4, 7, 20000);

-- Group 3

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(8, 9, 70000);


-- Group 4

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female01;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 13, 90000);

-- Group 5

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(14, 14, 110000);


LManager:AdjustGuestTolerance(130);


-- Custom event - effects path, x, y, delay


LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 85000 );

LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 110000 );

-- Set up the Level Settings
LManager:SetLevelNumber(1,8);
LManager:SetLevelScores(4500, 7000);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Uptempo_2.ogg","assets/audio/music/new_dance_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_backyard");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );